package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.brand.CategoryBrandRelDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.category.CategoryDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.brand.CategoryBrandRelQuerReyParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 品牌管理服务
 *
 * @author hjw
 * @date 2021/11/8 1:51 下午
 */
@AdvancedFeignClient
public interface RemoteCategoryService {


    /**
     * 创建一个类目
     *
     * @param parentCatId  如果是创建一级类目，那么请传0
     * @param sort         排序值
     * @param categoryName 类目名称
     * @return id
     * @throws BizException
     */
    Long createCategory(Long parentCatId, Integer sort, String categoryName) throws BizException;

    /**
     * 根据父级类目id 获取其下面的类目列表
     *
     * @param parentCategoryId 父级类目id
     * @param isShowOff        是否展示禁用类目
     * @return
     */
    List<CategoryDTO> getCategoryByParentCategoryId(Long parentCategoryId, boolean isShowOff);

    /**
     * 查询品牌下面的类目  分页查询
     *
     * @param categoryBrandRelQueryReyParam
     * @return
     * @throws BizException
     */
    PageResponse<CategoryBrandRelDTO> getCategoryByBrandId(CategoryBrandRelQuerReyParam categoryBrandRelQueryReyParam) throws BizException;

    /**
     * 交换两个类目的排序
     *
     * @param sourceId 源id
     * @param targetId 目标id
     * @return
     * @throws BizException
     */
    Boolean changeSort(Long sourceId, Long targetId) throws BizException;

    /**
     * 类目查询根据类目id
     *
     * @param categoryId 类目id
     * @return
     */
    CategoryDTO getById(Long categoryId) throws BizException;

    /**
     * 关系删除
     *
     * @param relId 关系id
     * @return
     * @throws BizException
     */
    Boolean deleteRel(Long relId) throws BizException;

    /**
     * 类目信息修改
     *
     * @param cateGoryId   类目id
     * @param categoryName l类目名称
     * @param status       状态枚举 {@link cn.com.duiba.cloud.goods.center.api.constant.StatusEnum}
     * @return
     * @throws BizException
     */
    Boolean categoryModify(Long cateGoryId, String categoryName, Integer status) throws BizException;
}
