package cn.com.duiba.duiba.goods.center.api.constant;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;

/**
 * @author xuanhongjian
 */

public enum CategoryOperaFailEnum {
    /**
     * 失败原因
     */
    CATEGORY_NAME_EXIST("类目名已存在", 1),
    parent_CATEGORY_NOT_EXIST("上级类目不存在", 2);

    private final String operate;
    private final Integer code;


    private static final ImmutableMap<Integer, CategoryOperaFailEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, CategoryOperaFailEnum> builder = ImmutableMap.builder();
        for (CategoryOperaFailEnum item : CategoryOperaFailEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    CategoryOperaFailEnum(String operate, Integer code) {
        this.operate = operate;
        this.code = code;
    }

    public String getOperate() {
        return operate;
    }

    public Integer getCode() {
        return code;
    }

    public static CategoryOperaFailEnum getByCode(Integer termValue) {
        return INNER_MAP.get(termValue);
    }
}
