package cn.com.duiba.duiba.goods.center.api.model.param;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 新增类目
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddCategoryParam implements Serializable {

    private static final long serialVersionUID = 8427011578815091229L;

    @NotNull(message = "类目等级不能为空")
    private Integer categoryLevel;

    private Long superiorCategory;

    @NotNull(message = "类目名称不能为空")
    private String categoryName;

    @NotNull(message = "顺序不能为空")
    private Integer sort;

    /**
     * 租户ID
     */
    private Long tenantId;
}
