package cn.com.duiba.duiba.goods.center.api.model.param;

import cn.com.duiba.wolf.entity.PageRequest;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 类目关联品牌查询
 *
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class CategoryAssociateAttributeQueryParam extends PageRequest {

    private static final long serialVersionUID = -7377981007044205078L;

    private Long attributeId;
    /**
     * 模糊查询按 创建时间降序排序
     */
    private String attributeName;
    private Integer state;

    @NotNull(message = "类目id不能为空")
    private Long categoryId;

    /**
     * 租户ID
     */
    private Long tenantId;
}
