package cn.com.duiba.duiba.goods.center.api.model.param;

import cn.com.duiba.wolf.entity.PageRequest;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class QueryCategoryParam extends PageRequest {

    private static final long serialVersionUID = 7429077206031833675L;

    /**
     * 类目等级
     */
    @NotNull(message = "类目等级不能为空")
    private Integer categoryLevel;

    @NotNull(message = "类目名称不能为空")
    private String categoryName;

    /**
     * 类目状态
     */
    private Integer state;

    /**
     * 租户ID
     */
    private Long tenantId;

}
