package cn.com.duiba.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.goods.center.api.model.dto.AttributeDTO;
import cn.com.duiba.duiba.goods.center.api.model.param.AddAttributeParam;
import cn.com.duiba.duiba.goods.center.api.model.param.AttributeQueryParam;
import cn.com.duiba.duiba.goods.center.api.model.param.UpdateAttributeParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteServiceAttribute {

   /**
    * 属性查询
    *
    * @param param 查询参数
    * @return AttributeDTO
    */
   PageResponse<AttributeDTO> queryAttribute(AttributeQueryParam param);

   /**
    * 启用/关闭属性
    *
    * @param attributeId 属性ID
    * @param state       开启/关闭
    * @return 操作结果
    */
   Boolean enableAttribute(Long attributeId, Integer state);

   /**
    * 删除属性
    *
    * @param attributeId 属性ID
    * @return 操作结果
    * @throws BizException 业务异常
    */
   Boolean deleteAttribute(Long attributeId) throws BizException;

   /**
    * 添加属性
    * @param addAttributeParam 参数
    * @return 操作结果
    */
   Boolean addAttribute(AddAttributeParam addAttributeParam);

   /**
    * 更新属性数据
    * @param updateAttributeParam 更新参数
    * @return 操作结果
    */
   Boolean updateAttribute(UpdateAttributeParam updateAttributeParam);

}
