package cn.com.duiba.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.goods.center.api.model.dto.CategoryAssociateAttributeDTO;
import cn.com.duiba.duiba.goods.center.api.model.dto.CategoryAssociateBrandDTO;
import cn.com.duiba.duiba.goods.center.api.model.dto.CategoryDTO;
import cn.com.duiba.duiba.goods.center.api.model.param.AddCategoryParam;
import cn.com.duiba.duiba.goods.center.api.model.param.AssociateAttributeParam;
import cn.com.duiba.duiba.goods.center.api.model.param.AssociateBrandParam;
import cn.com.duiba.duiba.goods.center.api.model.param.CategoryAssociateAttributeQueryParam;
import cn.com.duiba.duiba.goods.center.api.model.param.CategoryAssociateBrandQueryParam;
import cn.com.duiba.duiba.goods.center.api.model.param.QueryCategoryParam;
import cn.com.duiba.duiba.goods.center.api.model.param.SortCategoryParam;
import cn.com.duiba.wolf.entity.PageResponse;
import java.util.List;

/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
@SuppressWarnings("unused")
public interface RemoteServiceCategory {

    /**
     * 查询类目
     *
     * @param queryCategoryParam 查询参数
     * @return 类目信息
     */
    PageResponse<CategoryDTO> queryCategory(QueryCategoryParam queryCategoryParam);

    /**
     * 新增类目
     *
     * @param param 类目详情
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean addCategory(List<AddCategoryParam> param) throws BizException;

    /**
     * 移动节点
     *
     * @param sortCategoryParam 待排序节点
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean sortCategory(List<SortCategoryParam> sortCategoryParam) throws BizException;

    /**
     * 类目下品牌查询
     *
     * @param queryParam 查询参数
     * @return CategoryDTO
     */
    PageResponse<CategoryAssociateBrandDTO> associateBrandQuery(
        CategoryAssociateBrandQueryParam queryParam);


    /**
     * 类目下品牌查询
     *
     * @param queryParam 查询参数
     * @return CategoryDTO
     */
    PageResponse<CategoryAssociateAttributeDTO> associateAttributeQuery(
        CategoryAssociateAttributeQueryParam queryParam);

    /**
     * 删除品牌类目映射
     *
     * @param mappingId 映射ID
     * @return 操作结果
     */
    Boolean deleteAssociateBrand(Long mappingId);

    /**
     * 删除属性类目映射
     *
     * @param mappingId 映射ID
     * @return 操作结果
     */
    Boolean deleteAssociateAttribute(Long mappingId);

    /**
     * 关联属性
     * @param param 关联属性
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean associateBrand(AssociateAttributeParam param) throws BizException;

    /**
     * 关联属性
     * @param param 关联属性
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean associateAttribute(AssociateBrandParam param)throws BizException;

    /**
     * 修改类目名称
     * @param name 名称
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean updateCategoryName(String name) throws BizException;
}
