package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GoodsSourceEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * 商品包装类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/12 4:56 下午
 */
@Setter
@Getter
public class GoodsDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @JSONField(label = GoodsSnapshotUtil.LABEL_SNAPSHOT)
    private SpuDto spuDto;
    @JSONField(label = GoodsSnapshotUtil.LABEL_SNAPSHOT)
    private List<SkuDto> skuList;


    public static GoodsSourceEnum getGoodsSource(GoodsDto goodsDto) {
        return GoodsSourceEnum.getGoodsSourceEnum(goodsDto.getSpuDto().getAppId(), goodsDto.getSpuDto().getDetail().getAppId());
    }


    /**
     * 是否是自己的商品
     *
     * @param param
     *
     * @return
     */
    public boolean selfGoods(CurTenantParam param) {
        return Objects.equals(this.getSpuDto().getAppId(), param.getCurAppId());
    }

    /**
     * 判断商品是否被删除，支持供应商和租户
     */
    @Deprecated
    public boolean isDeleted() {
        return false;
    }

    /**
     * 快照Id，商品之外的系统用
     */
    public String generateSnapshotId() {
        return GoodsSnapshotUtil.getSnapshotId(this);
    }


}
