package cn.com.duiba.cloud.duiba.goods.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.Getter;

/**
 * 描述：商品来源类型，0-手动选品，1-定向选品
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/1 15:26
 */
@Getter
public enum SourceTypeEnum implements IEnum<Integer> {
    MANUAL(0, "手动选品"),
    CHANNEL(1, "定向选品"),
    ;
    private final Integer sourceType;
    private final String desc;

    SourceTypeEnum(Integer sourceType, String desc) {
        this.sourceType = sourceType;
        this.desc = desc;
    }


    @Override
    public Integer getDbCode() {
        return this.getSourceType();
    }
}
