package cn.com.duiba.cloud.duiba.goods.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 15:28
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum SpuAuditTypeEnum implements IEnum<Integer> {
    CREATE(1, "新增"),
    EDIT(2, "修改"),
    ;

    private final Integer auditType;
    private final String desc;

    SpuAuditTypeEnum(Integer shelfStatus, String desc) {
        this.auditType = shelfStatus;
        this.desc = desc;
    }

    public Integer getAuditType() {
        return auditType;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getAuditType();
    }
}