package cn.com.duiba.cloud.duiba.goods.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author xiaotian
 * @date 2022/5/24 10:50
 */

public enum SupplyEnum implements IEnum<String> {
    XIANGSHNG("xiangshang", "向上"),
    PUSHANG("pushang", "浦上"),
    FULU("fulu", "福禄"),
    ;

    private final String supplyCode;
    private final String desc;

    SupplyEnum(String supplyCode, String desc) {
        this.supplyCode = supplyCode;
        this.desc = desc;
    }

    public static SupplyEnum getByCode(String code) {
        for (SupplyEnum supplyEnum : SupplyEnum.values()) {
            if (supplyEnum.getSupplyCode().equals(code)) {
                return supplyEnum;
            }
        }
        return null;
    }

    /**
     * 提供话费的供应商
     *
     * @return
     */
    public static List<SupplyEnum> getPhoneSupply() {
        return Lists.newArrayList(XIANGSHNG, SupplyEnum.PUSHANG);
    }

    /**
     * 提供影音娱乐的供应商
     *
     * @return
     */
    public static List<SupplyEnum> getYYYLSupply() {
        return Lists.newArrayList(SupplyEnum.FULU, SupplyEnum.PUSHANG);
    }

    /**
     * 提供影音娱乐的供应商
     *
     * @return
     */
    public static List<SupplyEnum> getApiCoupon() {
        return Lists.newArrayList(SupplyEnum.FULU);
    }

    public String getSupplyCode() {
        return supplyCode;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public String getDbCode() {
        return getSupplyCode();
    }
}
