package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * 库存预警配置表(TbStockWarnConfig)实体类
 *
 * @author makejava
 * @since 2022-04-01 15:20:30
 */
@Getter
@Setter
public class StockWarnConfigDto extends BaseDto {
    private static final long serialVersionUID = 1L;
    /**
     * spuId
     */
    private Long spuId;
    /**
     * skuId
     */
    private Long skuId;
    /**
     * 库存预警阈值
     */
    private Long stockWarnValue;
    /**
     * 预警方式配置
     */
    private WarnConfig warnConfig;


    public static boolean equalsOjb(StockWarnConfigDto o1, StockWarnConfigDto o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        return Objects.equals(o1.spuId, o2.spuId) && Objects.equals(o1.skuId, o2.skuId) && Objects.equals(o1.stockWarnValue, o2.stockWarnValue) && Objects.equals(o1.warnConfig, o2.warnConfig);
    }
}

