package cn.com.duiba.cloud.duiba.goods.center.api.dto.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ConfigSwitchEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfConfigTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import lombok.Getter;
import lombok.Setter;

/**
 * sku定向渠道表(TbSkuChannelConfig)实体类
 * 渠道库存配置信息，要么是单纯的渠道库存配置信息，要么是已被定向的渠道库存配置信息
 *
 * @author makejava
 * @since 2022-04-01 15:21:14
 */
@Getter
@Setter
public class SkuChannelConfigDto extends BaseDto {
    private static final long serialVersionUID = 1L;
    /**
     * spuId
     */
    private Long spuId;
    /**
     * skuId
     */
    private Long skuId;
    /**
     * 渠道 id
     */
    private Long channelId;
    /**
     * 8位开关，0-是否开启独占库存，1-是否关闭共享库存
     *
     * @see ConfigSwitchEnum
     */
    private Integer configSwitch;
    /**
     * 扩展字段
     */
    private ConfigExtra configExtra;


    /**
     * 配置类型，0-指定渠道，1-全部渠道
     *
     * @see ShelfConfigTypeEnum
     */
    private Integer configType;
}

