package cn.com.duiba.cloud.duiba.goods.center.api.dto.sale;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.cloud.biz.tool.utils.EnumUtil;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ExchangeSwitchEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.wolf.entity.Pair;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * sku上架项DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:14 下午
 * @since 0.0.1
 **/
@Data
public class SkuSaleDTO implements Serializable {
    private static final long serialVersionUID = -2101769571491983947L;

    /**
     * sku上架项id
     */
    private Long skuSaleId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * sku名称
     */
    private String skuName;

    /**
     * spu名称
     */
    private String spuName;

    /**
     * 供货价
     */
    private Long supplyPrice;

    /**
     * 划线价
     */
    @Deprecated
    private Long facePrice;

    /**
     * 成本价
     *
     * @deprecated 成本价取上游的供货价
     */
    @Deprecated
    private Long costPrice;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 税率
     */
    private Short taxRate;

    /**
     * 上架状态(0:未上架,1:已上架)
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;

    /**
     * 来源应用id
     */
    private Long sourceAppId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 属性key，后端用，用于分辨sku
     */
    private String attributeKey;
    /**
     * 兑换积分数量
     */
    private Long credits;
    /**
     * 计算商品的兑换积分
     * 要么是根据应用汇率计算 要么是自定义积分  要么是自定义积分+金额
     *
     * @param baseSpuSaleDTO 是否采用自定义积分
     * @param creditRate     应用汇率配置  获取方法cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp.RemoteMallAppBaseConfService#getAppDefaultConf
     *
     * @return key=积分 value=价格(单位:分)
     * @throws BizException
     */
    public <T extends BaseSpuSaleDTO> Pair<Long, Long> calculateCredit(T baseSpuSaleDTO,
                                                                       Long creditRate) throws BizException {
        // 是否采用自定义
        boolean useCustom = EnumUtil.check(baseSpuSaleDTO.getExchangeSwitch(), ExchangeSwitchEnum.CUSTOM_CREDITS);
        return calculateCredit(useCustom, creditRate);
    }

    /**
     * 计算商品的兑换积分
     * 手动计算
     *
     * @param useCustom
     * @param supplyPrice skuSaleDTO.getSupplyPrice() or 话费的供应商价格
     * @param skuSaleDTO
     * @param creditRate
     *
     * @return
     * @throws BizException
     */
    public static Pair<Long, Long> calculateCredit(boolean useCustom,
                                                   Long supplyPrice,
                                                   SkuSaleDTO skuSaleDTO,
                                                   Long creditRate) throws BizException {
        Pair<Long, Long> result = new Pair<>();
        if (useCustom) {
            // case1:自定义积分
            Long customCredit = skuSaleDTO.getCredits();
            // fixme 暂无自定义价格需求
            // Long customPrice = skuSaleDTO.getCustomPrice;
            Long customPrice = null;
            Conditions.expectNotNull(customCredit, "缺少自定义积分设置");
            result.setKey(customCredit);
            result.setValue(customPrice);
            return result;
        } else {
            // case2:按汇率计算

            Conditions.expectNotNull(creditRate, "缺少应用汇率,无法计算换购");
            Conditions.expectNotNull(supplyPrice, "缺少售价,无法计算换购");

            long credits;
            if (supplyPrice == 0L) {
                credits = 0L;
            } else {
                // 兑换积分=售价(单位,分)*汇率/100，向上取整
                long v1 = supplyPrice * creditRate;
                credits = new BigDecimal(v1).divide(new BigDecimal(100), RoundingMode.CEILING).longValue();
            }
            result.setKey(credits);
        }
        return result;
    }

    public static void main(String[] args) {
        long supplyPrice = 99999999L;
        long creditRate = 999999L;

        System.out.println(new BigDecimal(1 * 1).divide(new BigDecimal(100), RoundingMode.CEILING).longValue());
        System.out.println(new BigDecimal(supplyPrice * creditRate).divide(new BigDecimal(100), RoundingMode.CEILING).longValue());
    }

    /**
     * 计算商品的兑换积分
     * 要么是根据应用汇率计算 要么是自定义积分  要么是自定义积分+金额
     *
     * @param useCustom  是否采用自定义
     * @param creditRate 应用汇率配置  获取方法cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp.RemoteMallAppBaseConfService#getAppDefaultConf
     *
     * @return key=积分 value=价格(单位:分)
     * @throws BizException
     */
    public Pair<Long, Long> calculateCredit(boolean useCustom,
                                            Long creditRate) throws BizException {
        Pair<Long, Long> result = new Pair<>();
        if (useCustom) {
            // case1:自定义积分
            Long customCredit = getCredits();
            // fixme 暂无自定义价格需求
            Long customPrice = null;
            Conditions.expectNotNull(customCredit, "缺少自定义积分设置");
            result.setKey(customCredit);
            result.setValue(customPrice);
            return result;
        } else {
            // case2:按汇率计算
            Long supplyPrice = getSupplyPrice();
            Conditions.expectNotNull(creditRate, "缺少应用汇率,无法计算换购");
            Conditions.expectNotNull(supplyPrice, "缺少售价,无法计算换购");

            long credits;
            if (supplyPrice == 0L) {
                credits = 0L;
            } else {
                // 兑换积分=售价(单位,分)*汇率/100，向上取整
                long v1 = supplyPrice * creditRate;
                credits = new BigDecimal(v1).divide(new BigDecimal(100), RoundingMode.CEILING).longValue();
            }
            result.setKey(credits);
        }
        return result;
    }
}