package cn.com.duiba.cloud.duiba.goods.center.api.dto.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.SpuAuditStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.SpuAuditTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * 商品审核表
 *
 * @TableName tb_spu_audit
 */
@Setter
@Getter
public class SpuAuditDTO extends BaseDto {
    private static final long serialVersionUID = 1L;
    /**
     * 1970-01-01 08:00:00
     */
    public static final Long DEFAULT_TIME_STAMP = 4070880000L * 1000L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型(1:实物,2:优惠券:3:充值,4:权益)
     */
    private Integer spuType;

    /**
     * 应用Id
     */
    private Long appId;

    /**
     * 发起员工id
     */
    private Long staffId;

    /**
     * 审核类型(1:新增,2:修改)
     *
     * @see SpuAuditTypeEnum
     */
    private Integer auditType;

    /**
     * 审核单状态(0:待审核,50:审核通过,99:审核拒绝)
     *
     * @see SpuAuditStatusEnum
     */
    private Integer auditStatus;

    /**
     * 审核员工id
     */
    private Long auditStaffId;

    /**
     * 审核备注
     */
    private String auditReason;

    /**
     * 审核内容,json
     */
    private String auditContent;
    /**
     * 审核前内容,json
     */
    private String auditContentBefore;

    /**
     * 审核时间
     */
    private Date auditTime;
}