package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Setter
@Getter
public class ChannelListParam implements Serializable {
    private static final long serialVersionUID = 1L;

    @Size(min = 1, max = 20)
    private List<Item> itemList = new ArrayList<>();

    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long spuId;
        private Long appId;

        public Item(Long spuId, Long appId) {
            this.spuId = spuId;
            this.appId = appId;
        }

        public Item() {
        }
    }
}
