package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 根据skuId列表获取详情
 *
 * @author xiaotian
 * @version 0.0.1
 * @date 2022/5/25 10:39 上午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class GetSkuListParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -9151302177253007480L;

    /**
     * spuId
     */
    @NotNull(message = "spuId不能为空")
    private Long spuId;

    /**
     * skuList
     */
    // @NotEmpty(message = "skuList不能为空")
    private List<Long> skuList;

    /**
     * 上架状态
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;
}