package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import cn.com.duiba.cloud.biz.tool.utils.EnumUtil;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ConfigSwitchEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfConfigTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.ConfigExtra;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.SkuChannelConfigDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * 描述：
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/9 14:03
 */
@Setter
@Getter
public class ShelfConfigOperateParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;


    /**
     * 渠道 Id,
     */
    private Long channelId;


    /**
     * 配置类型，0-指定渠道，1-全部渠道
     *
     * @see ShelfConfigTypeEnum
     */
    private Integer configType;


    /**
     * 是否开启独占库存
     */
    private Boolean monopolizeStock;
    private Long monopolizeStockNumber;

    /**
     * 是否关闭共享库存
     */
    private Boolean notShareStock;


    public SkuChannelConfigDto toDto(Long spuId, Long skuId) {
        SkuChannelConfigDto skuChannelConfigDto = new SkuChannelConfigDto();
        skuChannelConfigDto.setSpuId(spuId);
        skuChannelConfigDto.setSkuId(skuId);
        skuChannelConfigDto.setChannelId(getChannelId());
        skuChannelConfigDto.setConfigSwitch(EnumUtil.setSwitch(skuChannelConfigDto.getConfigSwitch(),
                                                               ConfigSwitchEnum.MONOPOLIZE_STOCK, getMonopolizeStock()));
        skuChannelConfigDto.setConfigSwitch(EnumUtil.setSwitch(skuChannelConfigDto.getConfigSwitch(),
                                                               ConfigSwitchEnum.NOT_SHARE_STOCK, getNotShareStock()));

        ConfigExtra configExtra = new ConfigExtra();
        configExtra.setMonopolizeStockNumber(getMonopolizeStockNumber());
        skuChannelConfigDto.setConfigExtra(configExtra);
        skuChannelConfigDto.setConfigType(getConfigType());

        Date now = new Date();
        skuChannelConfigDto.setGmtCreate(now);
        skuChannelConfigDto.setGmtModified(now);
        return skuChannelConfigDto;
    }


}
