package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.sale.ShelfStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 分页查询选品池sku列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class SupplyPageSkuParam extends PageSkuParam implements Serializable {
    private static final long serialVersionUID = 5316360552096468298L;

    /**
     * 商品所属的应用id
     */
    @NotNull(message = "商品所属的应用id不能为空")
    private Long sourceAppId;

    /**
     * 选品池中sku的状态应该默认为已上架
     */
    private Integer shelfStatus = ShelfStatusEnum.SHELVE.getDbCode();
}