package cn.com.duiba.cloud.duiba.goods.center.api.param.sale;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * 分页查询选品池spu列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:23 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class SupplyPageSpuParam extends PageSpuParam {
    private static final long serialVersionUID = 5626260601419137877L;

    /**
     * spuId
     */
    private Long spuId;
    private List<Long> spuIdList;

    /**
     * 应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 供应商应用id列表
     */
    @NotNull(message = "供应商应用id列表不能为空")
    @Size(min = 1, message = "供应商应用id列表不能为空")
    private List<Long> sourceAppIdList;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 选品开始时间
     */
    private Date beginTime;

    /**
     * 选品结束时间
     */
    private Date endTime;

    /**
     * 选品列表筛选条件，是否已选商品
     */
    private Integer isSelect;


    /**
     * 排序模式
     * 0-默认排序 1-供货价降序 2-供货价升序
     */
    private Integer sortMode = 0;


    /**
     * 已上架的最低供货价
     */
    private Long shelfSupplyPriceMin;

    /**
     * 已上架的最高供货价
     */

    private Long shelfSupplyPriceMax;
}