package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice.sale;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.BaseSpuSaleDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.SkuSaleDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.SpuToSkuDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.sale.TenantSpuSaleDTO;
import cn.com.duiba.cloud.duiba.goods.center.api.param.sale.*;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 上架项remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:44 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteSaleService {
//    /**
//     * 供应商分页查询spu列表
//     *
//     * @param supplierPageSpuParam 供应商分页查询spu请求参数
//     * @return spu列表
//     * @throws BizException 业务异常 {@link Error}
//     */
//    PageResponse<SupplierSpuSaleDTO> pageSupplierSpu(SupplierPageSpuParam supplierPageSpuParam) throws BizException;

//    /**
//     * 分页查询选品池spu列表
//     *
//     * @param supplyPageSpuParam 分页查询选品池spu列表请求参数
//     * @return spu列表
//     * @throws BizException 业务异常 {@link Error}
//     */
//    PageResponse<SupplySpuSaleDTO> pageSupplySpu(SupplyPageSpuParam supplyPageSpuParam) throws BizException;

    /**
     * 租户分页查询spu列表
     *
     * @param tenantPageSpuParam 租户分页查询spu列表请求参数
     * @return spu列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<TenantSpuSaleDTO> pageTenantSpu(TenantPageSpuParam tenantPageSpuParam) throws BizException;

//    /**
//     * 兑吧分页查询spu列表
//     *
//     * @param duibaPageSpuParam 兑吧分页查询spu列表请求参数
//     * @return spu列表
//     * @throws BizException 业务异常 {@link Error}
//     */
//    PageResponse<DuibaSpuSaleDTO> pageDuibaSpu(DuibaPageSpuParam duibaPageSpuParam) throws BizException;

    /**
     * 分页查询sku列表
     *
     * @param pageSkuParam 分页查询sku列表请求参数
     * @return sku列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<SkuSaleDTO> pageSkuSale(PageSkuParam pageSkuParam) throws BizException;

    /**
     * 分页查询sku列表(分appId)
     *
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<SkuSaleDTO> pageSkuSale4BatchAppId(PageSkuBatchParam param) throws BizException;


    /**
     * 根据spuId获取skuId列表
     *
     * @param getSkuIdListParam 根据spuId获取skuId列表请求参数
     * @return skuId列表
     */
    List<Long> getSkuIdListBySpuId(GetSkuIdListParam getSkuIdListParam);


    /**
     * 据skuId列表获取详情
     *
     * @param getSkuListParam 据skuId列表获取详情参数
     * @return skuId列表
     */
    List<SkuSaleDTO> getSaleSkuList(GetSkuListParam getSkuListParam);

    /**
     * 批量根据spuId获取skuId列表
     *
     * @param remoteBatchGetSkuIdListParam 批量根据spuId获取skuId列表请求参数
     * @return spu对sku映射关系
     */
    List<SpuToSkuDTO> batchGetSkuIdListBySpuId(RemoteBatchGetSkuIdListParam remoteBatchGetSkuIdListParam);


    /**
     * 批量检查商品是否被 appId 选品
     *
     * @param param
     * @return
     */
    List<BaseSpuSaleDTO> listSimpleByAppId(AppIdBatchParam param);


    /**
     * 更新商品是否售罄状态
     *
     * @param sellOutUpdateParam
     */
    void dealSellOut(RemoteSellOutUpdateParam sellOutUpdateParam);


    /**
     * 根据spuId、appId获取渠道信息
     *
     * @param channelListParam
     *
     * @return
     * @throws BizException
     */
    List<BaseSpuSaleDTO> listBySpuIdAppId(ChannelListParam channelListParam) throws BizException;
}