package cn.com.duiba.cloud.duiba.goods.center.api.util;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.SnapshotTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.goods.*;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.Labels;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/29 22:18
 */
public class GoodsSnapshotUtil {

    public static final String LABEL_SNAPSHOT = "snapshot";
    public static final String LABEL_TENANT = "tenant";
    public static final String LABEL_SUPPLIER = "supplier";
    public static final String SPLIT = "@";

    /**
     * 获取商品快照Id
     */
    public static String getSnapshotId(GoodsDto goodsDto) {
        GoodsSnapshotDto convert4Supplier = convert4Supplier(goodsDto);
        GoodsSnapshotDto convert4Tenant = convert4Tenant(goodsDto);

        return combineSnapshot(convert4Supplier, convert4Tenant);
    }

    public static GoodsSnapshotDto convert4Supplier(GoodsDto goodsDto) {
        SpuDto spuDto = goodsDto.getSpuDto();
        return new GoodsSnapshotDto(
                spuDto.getId(),
                spuDto.getAppId(), spuDto.getGmtModified(), SnapshotTypeEnum.SUPPLIER,
                GoodsSnapshotUtil.getSupplierSnapshotStr(goodsDto));
    }

    public static GoodsSnapshotDto convert4Tenant(GoodsDto goodsDto) {
        SpuDto spuDto = goodsDto.getSpuDto();
        GoodsDetailDto detail = spuDto.getDetail();
        return new GoodsSnapshotDto(
                spuDto.getId(),
                detail.getAppId(), detail.getGmtModified(), SnapshotTypeEnum.TENANT,
                GoodsSnapshotUtil.getTenantSnapshotStr(goodsDto));
    }

    public static String getSupplierSnapshotStr(GoodsDto goodsDto) {
        return JSON.toJSONString(goodsDto,
                                 Labels.includes(LABEL_SNAPSHOT, LABEL_SUPPLIER));
    }

    public static String getTenantSnapshotStr(GoodsDto goodsDto) {
        return JSON.toJSONString(goodsDto,
                                 Labels.includes(LABEL_SNAPSHOT, LABEL_TENANT));
    }

    @Deprecated
    public static Pair<String, String> splitSnapshot(String snapshotId) {
        String[] split = snapshotId.split(SPLIT);
        return Pair.from(split[0], split[1]);
    }

    /**
     * 合并租户快照、供应商快照
     *
     * @param destGoodsDto
     * @param supplierSnapshotStr
     * @param tenantSnapshotStr
     * @param skuId               是否指定sku
     */
    public static void assembleGoods(GoodsDto destGoodsDto,
                                     String supplierSnapshotStr,
                                     String tenantSnapshotStr,
                                     Long skuId) {
        GoodsDto supplierSnapshotDto = JSONObject.parseObject(supplierSnapshotStr, GoodsDto.class);
        GoodsDto tenantSnapshotDto = JSONObject.parseObject(tenantSnapshotStr, GoodsDto.class);

        BeanUtils.copy(supplierSnapshotDto, destGoodsDto);

        if (skuId != null) {
            // 过滤掉skuId

            destGoodsDto.setSkuList(destGoodsDto.getSkuList().stream()
                                            .filter(skuDto -> Objects.equals(skuDto.getId(), skuId))
                                            .collect(Collectors.toList()));
        }

        List<AbstractGoodsDto> dest = Lists.newArrayList(destGoodsDto.getSpuDto());
        dest.addAll(destGoodsDto.getSkuList());

        List<AbstractGoodsDto> source = Lists.newArrayList(tenantSnapshotDto.getSpuDto());
        source.addAll(tenantSnapshotDto.getSkuList());

        Map<String, AbstractGoodsDto> generalKeyMap = source.stream().collect(Collectors.toMap(GeneralBiz::generalKey, Function.identity()));

        for (AbstractGoodsDto dto : dest) {

            AbstractGoodsDto abstractGoodsDto = generalKeyMap.get(dto.generalKey());
            if (abstractGoodsDto != null) {
                dto.setDetail(abstractGoodsDto.getDetail());
                dto.setImageList(abstractGoodsDto.getImageList());
            }
        }
    }

    public static String combineSnapshot(GoodsSnapshotDto supplierSnapshotId, GoodsSnapshotDto tenantSnapshotId) {
        return supplierSnapshotId.getSnapshotId() + SPLIT + tenantSnapshotId.getSnapshotId();
    }


}
