package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 图文详情
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/15 10:54 上午
 */
@Setter
@Getter
public class GoodsDetailDto extends BaseDto implements Serializable, GeneralBiz, UserBiz {
    private static final long serialVersionUID = 1L;

    /**
     * spuName或skuName
     */
    private String generalName;
    /**
     * spu详情或sku详情
     */
    private String detailContent;

    /**
     * 审核状态(1:正常,2:待审核,3:审核失败)
     */
    private Integer reviewStatus;


    /**
     * spuID或skuID
     */
    private Long generalId;
    /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    private Integer generalType;

    /**
     * 快照Id
     */
    private String snapshotVersion;

    /**
     * 用户类型(1:平台;2:租户;3:用户)
     */
    private Integer userType;
    /**
     * 用户id
     */
    private Long userId;
}
