package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:47 下午
 */
@Getter
@Setter
public class SkuDto extends AbstractGoodsDto {
    private static final long serialVersionUID = 1L;


    /**
     * 主键
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 商品id
     */
    private Long spuId;
    /**
     * sku编码
     */
    private String skuCode;
    /**
     * 是否删除(0:未删除,1:已删除)
     */
    private Integer isDeleted;

    /**
     * spuID或skuID
     */
    @Override
    public Long getGeneralId() {
        return id;
    }

    /**
     * /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    @Override
    public Integer getGeneralType() {
        return GeneralTypeEnum.SKU.getGeneralType();
    }
}
