package cn.com.duiba.cloud.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.classify.ItemClassifyDto;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.classify.ItemClassifyRelationDto;
import cn.com.duiba.cloud.duiba.goods.center.api.param.classify.ClassifyDeleteParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.classify.ClassifyQueryParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.classify.ClassifyRelateParam;
import cn.com.duiba.cloud.duiba.goods.center.api.param.classify.ClassifyRelationQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 商品分组
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/15 10:07 上午
 */
@AdvancedFeignClient
public interface RemoteClassifyService {
    /**
     * 商品分组翻页查询
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    PageResponse<ItemClassifyDto> page(ClassifyQueryParam param) throws BizException;


    /**
     * 保存 or 更新
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Long save(ItemClassifyDto param) throws BizException;

    /**
     * 根据商品查询分组关系
     *
     * @param param 查询条件
     *
     * @return
     * @throws BizException
     */
    List<ItemClassifyRelationDto> list(ClassifyRelationQueryParam param) throws BizException;


    /**
     * 删除分组
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean deleteItemClassify(ClassifyDeleteParam param) throws BizException;

    /**
     * 删除分组关系
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean deleteItemClassifyRelation(ClassifyDeleteParam param) throws BizException;


    /**
     * 批量关联分组
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean batchRelateGoods2Classify(ClassifyRelateParam param) throws BizException;
}
