package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.MediaTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.param.goods.GoodsSnapshot;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 基于skuId的商品信息，主要是给订单列表用
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/30 11:36
 */
@Setter
@Getter
public class SimpleSkuDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 快照Id,必填
     */
    private String snapshotId;

    private Long spuId;
    private Long skuId;

    /**
     * 商品类型
     **/
    private Integer spuType;
    /**
     * 缩略图
     */
    private String smallImage;
    /**
     * 主图
     */
    private String mainImage;

    /**
     * 兑换项标题
     **/
    private String title;

    private List<SimpleAttributeDto> attr = new ArrayList<>();

    public SimpleSkuDto(GoodsSnapshot goodsSnapshot, GoodsDto goodsDto, Long skuId) {
        this();
        setSnapshotId(goodsSnapshot.getSnapshotId());
        setSkuId(skuId);

        List<AbstractGoodsDto> abstractGoodsDtoList = new ArrayList<>();
        Optional.ofNullable(goodsDto)
                .map(GoodsDto::getSpuDto)
                .ifPresent(spuDto -> {
                    setSpuId(spuDto.getId());
                    setSpuType(spuDto.getSpuType());

                    abstractGoodsDtoList.add(spuDto);
                });

        Optional<SkuDto> optional = Optional.ofNullable(goodsDto).map(GoodsDto::getSkuList).orElse(Collections.emptyList()).stream().filter(skuDto -> Objects.equals(skuDto.getId(), skuId)).findFirst();
        if (optional.isPresent()) {
            SkuDto skuDto = optional.get();

            List<GoodsAttributeDto> attributeList = skuDto.getAttributeList();
            setAttr(attributeList.stream().map(SimpleAttributeDto::new).collect(Collectors.toList()));

            abstractGoodsDtoList.add(skuDto);
        }

        // 按spu、sku顺序覆盖图片、名称
        for (AbstractGoodsDto abstractGoodsDto : abstractGoodsDtoList) {
            List<String> smallImageList = abstractGoodsDto.getImageByImageType(MediaTypeEnum.IMAGE_SMALL);
            if (CollectionUtils.isNotEmpty(smallImageList)) {
                setSmallImage(smallImageList.get(0));
            }

            List<String> mainImageList = abstractGoodsDto.getImageByImageType(MediaTypeEnum.IMAGE);
            if (CollectionUtils.isNotEmpty(mainImageList)) {
                setMainImage(mainImageList.get(0));
            }

            String title = Optional.ofNullable(abstractGoodsDto.getDetail()).map(GoodsDetailDto::getGeneralName).orElse(null);
            if (StringUtils.isNotBlank(title)) {
                setTitle(title);
            }
        }

    }

    public SimpleSkuDto() {
    }
}
