package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.constant.DeleteFlagEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuStatusEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuSwitchEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.constant.SubSpuTypeEnum;
import cn.com.duiba.cloud.duiba.goods.center.api.dto.UserBiz;
import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import cn.com.duiba.cloud.duiba.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:36 下午
 */
@Getter
@Setter
public class SpuDto extends AbstractGoodsDto implements UserBiz {
    private static final long serialVersionUID = 1L;
    /**
     * 品牌id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long brandId;
    /**
     * 商品类型(1:实物,2:优惠券:3:充值,4:权益)
     *
     * @see SpuTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer spuType;

    /**
     * 商品子类型
     *
     * @see SubSpuTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer subSpuType;
    /**
     * 应用Id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long appId;

    /**
     * 创建员工Id
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long staffId;

    /**
     * 商品状态(1:正常商品, 2:草稿箱商品, 3:审核中,4:审核失败)
     *
     * @see SpuStatusEnum
     */
    private Integer spuStatus;
    /**
     * 叶子类目
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long leafCategoryId;


    /**
     * 该spu下sku属性拼接
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String attributeKey;

    /**
     * 编码相关字段
     *
     * @see CodeDetail
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private CodeDetail codeDetail;


    /**
     * 开关
     *
     * @see SpuSwitchEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer spuSwitch;


    /**
     * 库存预警
     */
    private StockWarnConfigDto stockWarnConfigDto;

    /**
     * 是否删除(0:未删除,1:已删除)
     *
     * @see DeleteFlagEnum
     */
    private Integer isDeleted;


    /**
     * spuID或skuID
     */
    @Override
    public Long getGeneralId() {
        return getId();
    }

    /**
     * /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    @Override
    public Integer getGeneralType() {
        return GeneralTypeEnum.SPU.getGeneralType();
    }

    public boolean selfSpu(CurTenantParam param) {
        return Objects.equals(this.getAppId(), param.getCurAppId());
    }
}
