package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * 属性状态枚举
 *
 * @author xuanhongjian
 */
@Getter
public enum AttributeTypeEnum {
    /**
     * 属性现存状态
     */
    SKU_TYPE("规格属性", 2),
    PARAMETER_TYPE("参数属性", 1);

    private static final ImmutableMap<Integer, AttributeTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, AttributeTypeEnum> builder = ImmutableMap.builder();
        for (AttributeTypeEnum item : AttributeTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    /**
     * 属性描述
     */
    private final String desc;
    /**
     * 属性code
     */
    private final Integer code;

    AttributeTypeEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public static AttributeTypeEnum getByCode(Integer termValue) {
        return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
    }
}
