package cn.com.duiba.cloud.duiba.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.Getter;

/**
 * 描述：
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/8 16:17
 */
@Getter
public enum SpuSwitchEnum implements IEnum<Integer> {
    JUMP(0, "是否开启跳转"),
    SHOW_COUPON_CODE(1, "是否展示卡券条形码"),
    FILL_ACCOUNT(2, "是否需要填写账号信息"),
    STOCK_WARN(3, "是否开启库存预警"),
    COUPON_LATER(4, "是否延迟发货、稍后发货、接口发券"),
    NO_STOCK_LIMIT(5, "无库存限制"),
    COUPON_API(6, "是否接口发券"),
    ;


    private final Integer spuSwitch;
    private final String desc;

    SpuSwitchEnum(Integer spuSwitch, String desc) {
        this.spuSwitch = spuSwitch;
        this.desc = desc;
    }


    @Override
    public Integer getDbCode() {
        return getSpuSwitch();
    }
}
