package cn.com.duiba.cloud.duiba.goods.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 6:23 下午
 **/
@Data
public class CouponDetailDTO implements Serializable {

    private static final long serialVersionUID = -4514739584503785529L;

    /**
     * 券码id
     */
    private Long couponCardId;

    /**
     * 卡券id
     */
    private Long couponId;

    /**
     * 卡券批次id
     */
    private Long couponBatchId;

    /**
     * 领取人
     */
    private String userId;

    /**
     * 领取的应用id
     */
    private Long appId;

    /**
     * 领取时间 取巧字段 领取以后这条记录就不该变化
     */
    private Date gmtModified;

    /**
     * 卡券批次名称
     */
    private String couponBatchName;

    /**
     * 券码
     */
    private String cardNo;

    /**
     * 卡密
     */
    private String cardPassword;

    /**
     * 卡券类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.CouponTypeEnum
     */
    private Integer couponType;

    /**
     * 使用状态 1-已使用 0-未使用
     */
    private Integer isUsed;
}