package cn.com.duiba.cloud.duiba.goods.center.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;

/**
 * 当前租户含义
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/8 1:52 下午
 */
@Getter
@Setter
public class CurTenantParam extends PageRequest {
    private static final long serialVersionUID = 2209398723528103578L;
    /**
     * 当前appId
     */
    private Long curAppId;

    /**
     * 当前员工Id
     */
    private Long curStaffId;

    public CurTenantParam() {
        super(1, 10);
    }

    public CurTenantParam(Long curAppId, Long curStaffId) {
        this.curAppId = curAppId;
        this.curStaffId = curStaffId;
    }


    /**
     *
     */
    public boolean hasUser() {
        return Objects.nonNull(curAppId);
    }
}
