package cn.com.duiba.cloud.duiba.goods.center.api.dto.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.dto.BaseDto;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

@Getter
@Setter
public class VipGoodsDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 状态  0停用  1启用
     */
    private boolean status;

    /**
     * vip等级  ,分割
     */
    private String vipLevels;

    /**
     * 商品名称
     */
    private String title;

    private List<VipGoodsInfo> vipSkuInfo;

    @Getter
    @Setter
    public static class VipGoodsInfo implements Serializable {
        /**
         * skuid
         */
        private Long skuId;
        /**
         * sku规格名称
         */
        private String title;
        /**
         * 价格
         */
        private Long price;
        /**
         * 积分
         */
        private Long credits;
        /**
         * 折扣
         */
        private List<VipGoodsDiscount> vipGoodsDiscounts;
    }

    @Getter
    @Setter
    public static class VipGoodsDiscount implements Serializable {
        /**
         * 折扣
         */
        private String discount;
        /**
         * vip等级
         */
        private Long vipLevel;
    }
}
