package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 通过skuId使用卡券
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/4/19 5:33 下午
 **/
@Data
public class CouponUseParam implements Serializable {
    private static final long serialVersionUID = -937314310408840975L;
    /**
     * 领取的appId
     */
    @NotNull(message = "领取应用id不能为空")
    private Long useAppId;

    /**
     * 领取人id
     */
    @NotNull(message = "领取人id不能为空")
    private String userId;

    /**
     * 用于幂等处理
     */
    @NotNull(message = "业务编号")
    private String bizNo;

    /**
     * 使用数量
     */
    @NotNull(message = "使用数量不能为空")
    @Min(1)
    private Integer num;
}
