package cn.com.duiba.cloud.duiba.goods.center.api.param.coupon;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/3/15 6:29 下午
 **/
@Data
public class IssueCouponParam implements Serializable {

    private static final long serialVersionUID = -3754131267420892969L;
    /**
     * 卡券id
     */
    @NotNull(message = "卡券id不能为空")
    private Long couponId;

    /**
     * 当前操作人id
     */
    @NotNull(message = "当前操作人id不能为空")
    private Long operatorId;

    /**
     * 卡券批次id
     */
    @NotNull(message = "卡券批次id不能为空")
    private Long totalCouponBatchId;

    /**
     * 普通卡券id 分配现有卡券库时塞入这个值
     */
    private Long normalCouponId;

    /**
     * 卡券名称
     */
    private String couponName;

    /**
     * 有效期开始时间
     */
    @NotNull(message = "有效期开始时间不能为空")
    private Date startTime;

    /**
     * 有效期截止时间
     */
    @NotNull(message = "有效期截止时间不能为空")
    private Date endTime;

    /**
     * 分配数量
     */
    @NotNull(message = "分配数量不能为空")
    private Integer issueNumber;
}