package cn.com.duiba.cloud.duiba.goods.center.api.param.goods;

import cn.com.duiba.cloud.duiba.goods.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/13 15:15
 */
@Setter
@Getter
public class GoodsBatchUpdateParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    @Valid
    @Size(min = 1, message = "选品列表不允许为空")
    private List<Item> list = new ArrayList<>();

    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;
        @NotNull(message = "商品编码不允许为空")
        private Long spuId;
        /**
         * 修改类目，为空则不修改类目
         */
        private Long leafCategoryId;

        public Item(Long spuId, Long leafCategoryId) {
            this.spuId = spuId;
            this.leafCategoryId = leafCategoryId;
        }

        public Item() {
        }
    }
}
