package cn.com.duiba.cloud.duiba.http.client.handler.http.result.impl;

import cn.com.duiba.cloud.duiba.http.client.handler.http.result.HttpClientResultHandler;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.HttpClientFileUtil;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 *
 * @date : 2021/12/12 15:53
 * @author: linzhou
 * @description : 文件返回处理
 */
@Component
@Order(-1)
public class FileHttpClientResultHandler implements HttpClientResultHandler {
    @Override
    public Object getReturnObject(HttpClientResponse response, Class<?> returnType) throws Exception {
        if (returnType == File.class) {
            return HttpClientFileUtil.downFile(response);
        }
        return null;
    }
}
