package cn.com.duiba.cloud.duiba.http.client.handler.analysis.method;

import cn.com.duiba.cloud.duiba.http.client.utils.SpringUtil;
import org.apache.commons.collections4.CollectionUtils;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;

/**
 *
 * @date : 2021/12/12 15:03
 * @author: linzhou
 * @description : AnalysisMethodParamHandlerManager
 */
public class AnalysisMethodParamHandlerManager {

    private static List<AnalysisMethodParamHandler> analysisMethodParamHandlers;

    public static Object analysisMethodParam(Object param, Annotation[] annotations) throws Exception {

        List<AnalysisMethodParamHandler> analysisMethodParamHandlers = getAnalysisMethodParamHandlers();

        for (AnalysisMethodParamHandler analysisMethodParamHandler : analysisMethodParamHandlers) {
            Object rlt = analysisMethodParamHandler.analysisMethodParam(param, annotations);
            if (Objects.nonNull(rlt)){
                return rlt;
            }
        }
        return null;
    }

    private static List<AnalysisMethodParamHandler> getAnalysisMethodParamHandlers(){
        if (CollectionUtils.isEmpty(analysisMethodParamHandlers)){
            analysisMethodParamHandlers = SpringUtil.getBeanList(AnalysisMethodParamHandler.class);
        }
        return analysisMethodParamHandlers;
    }

}
