package cn.com.duiba.cloud.duiba.http.client.proxy;


import cn.com.duiba.cloud.duiba.http.client.context.HttpRequestContext;
import cn.com.duiba.cloud.duiba.http.client.context.body.FileBody;
import cn.com.duiba.cloud.duiba.http.client.context.form.Form;
import cn.com.duiba.cloud.duiba.http.client.context.header.HttpHeader;
import cn.com.duiba.cloud.duiba.http.client.factorybean.HttpFactoryBean;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.AutoCloseUtil;
import cn.com.duiba.cloud.duiba.http.client.utils.IoStreamUtils;
import cn.com.duiba.cloud.duiba.http.client.utils.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HTTP;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName DefaultHttpProxy.java
 * @Description TODO
 * @createTime 2021年07月05日 16:25:00
 */
@Slf4j
public class DefaultHttpProxy extends AbstractHttpProxy implements InvocationHandler {

    private HttpFactoryBean httpFactoryBean;

    private CloseableHttpClient client;

    public static final String DEFAULT_ENCODING = "UTF-8";


    @Override
    protected HttpClientResponse doInvoke(HttpRequestContext context) throws Throwable {

        HttpRequestBase httpRequest;

        if (isGet(context)) {
            httpRequest = new HttpGet(context.getHttpUrl());
        } else {
            httpRequest = getHttpPost(context);
        }
        setHeader(httpRequest,context);
        try (CloseableHttpResponse response = getClient().execute(httpRequest)){
            //设置自动关闭,在请求结束后自动关闭response
//            AutoCloseUtil.addCloseable(response);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            InputStream content = entity.getContent();

            HttpHeader headers = getHeaders(response);
            Charset charset = getCharset(entity);
            return HttpClientResponse.builder()
                    .charset(charset)
                    .httpHeader(headers)
                    .inputStream(IoStreamUtils.copyInputStream(content))
                    .code(statusCode)
                    .build();

        } catch (Exception e) {
            throw e;
        }
    }

    private void setHeader(HttpRequestBase httpRequest, HttpRequestContext context) {
        Map<String, List<String>> headers = context.getHttpHeader().getHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                httpRequest.addHeader(key,value);
            }
        }
    }

    private Charset getCharset(HttpEntity entity) {
        ContentType contentType = ContentType.get(entity);
        if (Objects.nonNull(contentType)) {
            return contentType.getCharset();
        }
        return HTTP.DEF_CONTENT_CHARSET;
    }

    private HttpHeader getHeaders(CloseableHttpResponse response) {
        Header[] allHeaders = response.getAllHeaders();
        HttpHeader httpHeader = new HttpHeader();
        for (Header header : allHeaders) {
            httpHeader.addHeader(header.getName(), header.getValue());
        }
        return httpHeader;
    }

    /**
     * 创建post请求
     *
     * @param context
     * @return
     * @throws UnsupportedEncodingException
     */
    private HttpRequestBase getHttpPost(HttpRequestContext context) throws Throwable {
        String body = context.getBody();
        String url = context.getHttpUrl();
        HttpPost httpPost = new HttpPost(url);

        HttpEntity entity = getHttpEntity(context);
        if (entity != null) {
            //设置entity
            httpPost.setEntity(entity);
        }
        return httpPost;
    }

    private HttpEntity getHttpEntity(HttpRequestContext context) throws IOException {

        if (StringUtils.isNotBlank(context.getBody())) {
            //设置body
            return new StringEntity(context.getBody(), DEFAULT_ENCODING);
        }
        //设置文件上传
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        //加上此行代码解决返回中文乱码问题
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        List<FileBody> uploadFiles = context.getUploadFiles();
        if (CollectionUtils.isNotEmpty(uploadFiles)) {
            FileBody fileBody = uploadFiles.get(0);

            ByteArrayBody byteArrayBody = new ByteArrayBody(fileBody.getFileBytes(), fileBody.getFileName());
            String value = StringUtils.isBlank(fileBody.getName()) ? "file" : fileBody.getName();
            builder.addPart(value, byteArrayBody);

        }

        List<Form> nameValueParams = context.getNameValueParams();
        if (CollectionUtils.isNotEmpty(nameValueParams)) {
            for (Form nameValueParam : nameValueParams) {
                builder.addTextBody(nameValueParam.getName(), nameValueParam.getValue(),nameValueParam.getContentType());
            }
        }
        return builder.build();
    }


    public CloseableHttpClient getClient() {
        if (Objects.isNull(client)) {
            this.client = SpringUtil.getBean(CloseableHttpClient.class);
        }
        return client;
    }
}
