package cn.com.duiba.cloud.duiba.http.client.utils;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**

 * @date : 2021/12/12 15:07
 * @author: linzhou
 * @description : SpringUtil
 */
@Component
public class SpringUtil implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    /**
     * 获取指定类型的bean集合
     *
     * @param tClass
     * @param <T>
     * @return
     */
    public static <T> List<T> getBeanList(Class<T> tClass) {
        Map<String, T> beansOfType = applicationContext.getBeansOfType(tClass);
        List<T> rlt = new ArrayList<>(beansOfType.size());
        rlt.addAll(beansOfType.values());
        rlt.sort(Comparator.comparingInt(SpringUtil::getOrder));
        return rlt;
    }

    /**
     * 获取指定类型的bean
     *
     * @param tClass
     * @param <T>
     * @return
     */
    public static <T> T getBean(Class<T> tClass) {
        return applicationContext.getBean(tClass);
    }
    /**
     * 获取指定类型的bean
     *
     * @param <T>
     * @return
     */
    public static <T> T getBean(String beanName) {
        return (T) applicationContext.getBean(beanName);
    }
    /**
     * 获取指定类型的bean
     *
     * @param <T>
     * @return
     */
    public static <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return applicationContext.getBean(name,requiredType);
    }


    public static int getOrder(Object o) {
        Order order = AnnotationUtils.findAnnotation(o.getClass(), Order.class);
        if (order != null) {
            return order.value();
        }
        return 0;
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtil.applicationContext = applicationContext;
    }
}
