/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.context;

import cn.com.duiba.cloud.duiba.http.client.annotation.HttpClient;
import cn.com.duiba.cloud.duiba.http.client.bo.HttpClientRequest;
import cn.com.duiba.cloud.duiba.http.client.context.body.FileBody;
import cn.com.duiba.cloud.duiba.http.client.context.form.Form;
import cn.com.duiba.cloud.duiba.http.client.context.header.HttpHeader;
import cn.com.duiba.cloud.duiba.http.client.enums.HttpRequestMethod;
import cn.com.duiba.cloud.duiba.http.client.factorybean.HttpFactoryBean;
import cn.com.duiba.cloud.duiba.http.client.utils.UrlUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HttpRequestContext {
    private Object proxy;
    private Method method;
    private HttpClient methodAnnotation;
    private HttpClient interfaceHttpClient;
    private Annotation[][] parameterAnnotations;
    private HttpFactoryBean httpFactoryBean;
    private Object[] args;
    private HttpRequestMethod httpRequestMethod;
    private HttpClientRequest param;
    private String httpUrl;
    private Class<?> type;

    public HttpRequestContext(HttpFactoryBean httpFactoryBean, Object proxy, Method method, Object[] args) {
        this.method = method;
        this.httpFactoryBean = httpFactoryBean;
        this.args = args;
        this.methodAnnotation = method.getAnnotation(HttpClient.class);
        this.parameterAnnotations = method.getParameterAnnotations();
        this.httpRequestMethod = this.getHttpRequestMethod();
        this.type = httpFactoryBean.getType();
        this.interfaceHttpClient = this.type.getAnnotation(HttpClient.class);
    }

    public String getBaseUrl(String defaultBaseUrl) {
        if (this.param.getHttpUrl() != null) {
            return this.param.getHttpUrl().getUrl();
        }
        String url = this.getUrl(defaultBaseUrl);
        if (StringUtils.isNotBlank((CharSequence)this.httpFactoryBean.getBasePath())) {
            url = UrlUtil.splicingUrl(url, this.httpFactoryBean.getBasePath());
        }
        String path = "";
        if (this.methodAnnotation != null) {
            path = this.methodAnnotation.path();
            if (StringUtils.isBlank((CharSequence)path) && this.methodAnnotation.pathMethodName()) {
                path = this.method.getName();
            }
        } else if (this.httpFactoryBean.isPathMethodName()) {
            path = this.method.getName();
        }
        return UrlUtil.splicingUrl(url, path);
    }

    private String getUrl(String defaultBaseUrl) {
        String url;
        String string = url = Objects.isNull(this.methodAnnotation) ? null : UrlUtil.getUrl(this.methodAnnotation);
        if (StringUtils.isBlank((CharSequence)url)) {
            url = UrlUtil.getUrl(this.interfaceHttpClient);
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            if (StringUtils.isNotBlank((CharSequence)defaultBaseUrl)) {
                url = defaultBaseUrl;
            } else {
                throw new IllegalArgumentException("url:error,url is blank");
            }
        }
        if (!url.contains("://")) {
            url = "https://" + url;
        }
        return url;
    }

    public boolean isPostEntity() {
        if (this.httpRequestMethod != HttpRequestMethod.POST) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)this.param.getBody());
    }

    public HttpRequestMethod getHttpRequestMethod() {
        HttpRequestMethod httpRequestMethod;
        if (this.httpRequestMethod != null) {
            return this.httpRequestMethod;
        }
        HttpRequestMethod httpRequestMethod2 = httpRequestMethod = this.methodAnnotation != null ? this.methodAnnotation.method() : null;
        if (httpRequestMethod == null || httpRequestMethod == HttpRequestMethod.NULL) {
            httpRequestMethod = this.httpFactoryBean.getMethod();
        }
        if (httpRequestMethod == HttpRequestMethod.NULL) {
            httpRequestMethod = HttpRequestMethod.GET;
        }
        return httpRequestMethod;
    }

    public List<Form> getNameValueParams() {
        if (Objects.nonNull(this.param)) {
            return this.param.getForms();
        }
        return Collections.emptyList();
    }

    public List<FileBody> getUploadFiles() {
        if (Objects.nonNull(this.param)) {
            return this.param.getUploadFiles();
        }
        return Collections.emptyList();
    }

    public HttpHeader getHttpHeader() {
        if (Objects.nonNull(this.param)) {
            return this.param.getHttpHeader();
        }
        return null;
    }

    public String getBody() {
        if (Objects.nonNull(this.param)) {
            return this.param.getBody();
        }
        return null;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpClient getMethodAnnotation() {
        return this.methodAnnotation;
    }

    public HttpClient getInterfaceHttpClient() {
        return this.interfaceHttpClient;
    }

    public Annotation[][] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public HttpFactoryBean getHttpFactoryBean() {
        return this.httpFactoryBean;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public HttpClientRequest getParam() {
        return this.param;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodAnnotation(HttpClient methodAnnotation) {
        this.methodAnnotation = methodAnnotation;
    }

    public void setInterfaceHttpClient(HttpClient interfaceHttpClient) {
        this.interfaceHttpClient = interfaceHttpClient;
    }

    public void setParameterAnnotations(Annotation[][] parameterAnnotations) {
        this.parameterAnnotations = parameterAnnotations;
    }

    public void setHttpFactoryBean(HttpFactoryBean httpFactoryBean) {
        this.httpFactoryBean = httpFactoryBean;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public void setHttpRequestMethod(HttpRequestMethod httpRequestMethod) {
        this.httpRequestMethod = httpRequestMethod;
    }

    public void setParam(HttpClientRequest param) {
        this.param = param;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestContext)) {
            return false;
        }
        HttpRequestContext other = (HttpRequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$proxy = this.getProxy();
        Object other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        HttpClient this$methodAnnotation = this.getMethodAnnotation();
        HttpClient other$methodAnnotation = other.getMethodAnnotation();
        if (this$methodAnnotation == null ? other$methodAnnotation != null : !this$methodAnnotation.equals(other$methodAnnotation)) {
            return false;
        }
        HttpClient this$interfaceHttpClient = this.getInterfaceHttpClient();
        HttpClient other$interfaceHttpClient = other.getInterfaceHttpClient();
        if (this$interfaceHttpClient == null ? other$interfaceHttpClient != null : !this$interfaceHttpClient.equals(other$interfaceHttpClient)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getParameterAnnotations(), (Object[])other.getParameterAnnotations())) {
            return false;
        }
        HttpFactoryBean this$httpFactoryBean = this.getHttpFactoryBean();
        HttpFactoryBean other$httpFactoryBean = other.getHttpFactoryBean();
        if (this$httpFactoryBean == null ? other$httpFactoryBean != null : !this$httpFactoryBean.equals(other$httpFactoryBean)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
            return false;
        }
        HttpRequestMethod this$httpRequestMethod = this.getHttpRequestMethod();
        HttpRequestMethod other$httpRequestMethod = other.getHttpRequestMethod();
        if (this$httpRequestMethod == null ? other$httpRequestMethod != null : !((Object)((Object)this$httpRequestMethod)).equals((Object)other$httpRequestMethod)) {
            return false;
        }
        HttpClientRequest this$param = this.getParam();
        HttpClientRequest other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        String this$httpUrl = this.getHttpUrl();
        String other$httpUrl = other.getHttpUrl();
        if (this$httpUrl == null ? other$httpUrl != null : !this$httpUrl.equals(other$httpUrl)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        HttpClient $methodAnnotation = this.getMethodAnnotation();
        result = result * 59 + ($methodAnnotation == null ? 43 : $methodAnnotation.hashCode());
        HttpClient $interfaceHttpClient = this.getInterfaceHttpClient();
        result = result * 59 + ($interfaceHttpClient == null ? 43 : $interfaceHttpClient.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getParameterAnnotations());
        HttpFactoryBean $httpFactoryBean = this.getHttpFactoryBean();
        result = result * 59 + ($httpFactoryBean == null ? 43 : $httpFactoryBean.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        HttpRequestMethod $httpRequestMethod = this.getHttpRequestMethod();
        result = result * 59 + ($httpRequestMethod == null ? 43 : ((Object)((Object)$httpRequestMethod)).hashCode());
        HttpClientRequest $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        String $httpUrl = this.getHttpUrl();
        result = result * 59 + ($httpUrl == null ? 43 : $httpUrl.hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequestContext(proxy=" + this.getProxy() + ", method=" + this.getMethod() + ", methodAnnotation=" + this.getMethodAnnotation() + ", interfaceHttpClient=" + this.getInterfaceHttpClient() + ", parameterAnnotations=" + Arrays.deepToString((Object[])this.getParameterAnnotations()) + ", httpFactoryBean=" + this.getHttpFactoryBean() + ", args=" + Arrays.deepToString(this.getArgs()) + ", httpRequestMethod=" + (Object)((Object)this.getHttpRequestMethod()) + ", param=" + this.getParam() + ", httpUrl=" + this.getHttpUrl() + ", type=" + this.getType() + ")";
    }
}

