/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.context.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class HttpHeader {
    private Map<String, List<String>> headers;

    public HttpHeader() {
        this.headers = new HashMap<String, List<String>>();
    }

    public HttpHeader(Map<String, List<String>> header) {
        this.headers = header != null ? header : new HashMap<String, List<String>>();
    }

    public void addHeader(HttpHeader httpHeader) {
        if (httpHeader != null && !httpHeader.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : httpHeader.getHeaders().entrySet()) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addHeader(String key, String value) {
        List<String> values = this.headers.get(key);
        if (Objects.isNull(values)) {
            values = new ArrayList<String>();
            this.headers.put(key, values);
        }
        values.add(value);
    }

    public void addHeader(String key, List<String> addValues) {
        List<String> values = this.headers.get(key);
        if (Objects.isNull(values)) {
            values = new ArrayList<String>();
            this.headers.put(key, values);
        }
        values.addAll(addValues);
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public void clearHeader() {
        this.headers.clear();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        if (Objects.isNull(headers)) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public String getHeader(String name, String defaultValue) {
        List<String> values;
        if (this.headers.containsKey(name) && CollectionUtils.isNotEmpty(values = this.headers.get(name))) {
            return values.get(0);
        }
        return defaultValue;
    }
}

