/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.impl.body;

import cn.com.duiba.cloud.duiba.http.client.annotation.HttpFile;
import cn.com.duiba.cloud.duiba.http.client.bo.FileParam;
import cn.com.duiba.cloud.duiba.http.client.context.body.FileBody;
import cn.com.duiba.cloud.duiba.http.client.context.body.UploadFile;
import cn.com.duiba.cloud.duiba.http.client.context.body.UploadMultipartFile;
import cn.com.duiba.cloud.duiba.http.client.exception.ParamException;
import cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.AnalysisMethodParamHandler;
import cn.com.duiba.cloud.duiba.http.client.utils.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class HttpFileHandler
implements AnalysisMethodParamHandler {
    @Override
    public Object analysisMethodParam(Object param, Annotation[] annotations) throws IOException {
        HttpFile httpFile = AnnotationUtil.findHttpAnnotation(annotations, HttpFile.class);
        if (Objects.nonNull(httpFile)) {
            return this.getUploadFile(param, httpFile);
        }
        return null;
    }

    private FileBody getUploadFile(Object arg, HttpFile httpFile) throws IOException {
        FileBody uploadFile;
        if (arg instanceof MultipartFile) {
            uploadFile = new UploadMultipartFile(httpFile, (MultipartFile)arg);
        } else if (arg instanceof FileParam) {
            FileParam fileParam = (FileParam)arg;
            uploadFile = new UploadMultipartFile(httpFile, fileParam.getFile(), fileParam.getParam());
        } else if (arg instanceof File) {
            uploadFile = new UploadFile(httpFile, (File)arg);
        } else {
            throw new ParamException("\u53c2\u6570\u683c\u5f0f\u9519\u8bef,\u4e0a\u4f20\u6587\u4ef6\u5e94\u4e3aMultipartFile\u6216\u8005file\u7c7b\u578b,\u5f53\u524d\u7c7b\u578b:" + arg.getClass().getName());
        }
        return uploadFile;
    }
}

