/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.impl.form;

import cn.com.duiba.cloud.duiba.http.client.annotation.HttpParam;
import cn.com.duiba.cloud.duiba.http.client.context.form.NameValueParam;
import cn.com.duiba.cloud.duiba.http.client.exception.ParamException;
import cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.AnalysisMethodParamHandler;
import cn.com.duiba.cloud.duiba.http.client.utils.AnnotationUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class HttpParamNotBasicClassHandler
implements AnalysisMethodParamHandler {
    @Override
    public Object analysisMethodParam(Object param, Annotation[] annotations) {
        HttpParam httpParam = AnnotationUtil.findHttpAnnotation(annotations, HttpParam.class);
        if (Objects.nonNull(httpParam) && !this.isBasicClass(param) && !(param instanceof Collection)) {
            return this.getNameValueParam(param, httpParam);
        }
        return null;
    }

    private List<NameValueParam> getNameValueParam(Object arg, HttpParam httpParam) {
        if (arg == null) {
            return Collections.emptyList();
        }
        Object o = JSONObject.toJSON((Object)arg);
        if (!(o instanceof JSONObject)) {
            throw new ParamException("\u7c7b\u578b\u9519\u8bef,error class:" + arg.getClass().getName());
        }
        ArrayList<NameValueParam> nameValueParams = new ArrayList<NameValueParam>();
        JSONObject jsonObject = (JSONObject)o;
        for (Map.Entry entry : jsonObject.entrySet()) {
            String value = this.objectToString(entry.getValue());
            if (StringUtils.isBlank((CharSequence)value)) continue;
            NameValueParam nameValueParam = new NameValueParam((String)entry.getKey(), value);
            nameValueParams.add(nameValueParam);
        }
        return nameValueParams;
    }

    private String objectToString(Object o) {
        if (Objects.isNull(o)) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return JSON.toJSONString((Object)o);
    }

    protected boolean isBasicClass(Object o) {
        return o instanceof Integer || o instanceof String || o instanceof Double || o instanceof Float || o instanceof Long || o instanceof BigDecimal;
    }
}

