/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.handler.http.result.impl;

import cn.com.duiba.cloud.duiba.http.client.handler.http.result.HttpClientResultHandler;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.JsonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order
public class ObjectResultHandler
implements HttpClientResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(ObjectResultHandler.class);

    @Override
    public Object getReturnObject(HttpClientResponse response, Class<?> returnType) throws Exception {
        String result = response.string();
        if (returnType == String.class) {
            return result;
        }
        Object object = this.toJson(result);
        if (!(object instanceof JSON)) {
            return null;
        }
        JSON jsonObject = (JSON)object;
        this.toObject(jsonObject);
        Type genericReturnType = response.getContext().getMethod().getGenericReturnType();
        return jsonObject.toJavaObject(genericReturnType);
    }

    private void toObject(JSON json) {
        if (Objects.isNull(json)) {
            return;
        }
        if (json instanceof JSONObject) {
            this.toObject((JSONObject)json);
        } else {
            this.toObject((JSONArray)json);
        }
    }

    private void toObject(JSONArray jsonArray) {
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object value = jsonArray.get(i);
            if (value instanceof String) {
                value = this.toJson((String)value);
                jsonArray.set(i, value);
            }
            if (!(value instanceof JSON)) continue;
            this.toObject((JSON)value);
        }
    }

    private void toObject(JSONObject jsonObject) {
        if (Objects.isNull(jsonObject) || jsonObject.isEmpty()) {
            return;
        }
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (Objects.isNull(value)) continue;
            if (value instanceof String) {
                value = this.tryToObject(jsonObject, key, (String)value);
            }
            if (!(value instanceof JSON)) continue;
            this.toObject((JSON)value);
        }
    }

    private Object tryToObject(JSONObject jsonObject, String fieldName, String s) {
        try {
            Object parse = this.toJson(s);
            jsonObject.put(fieldName, parse);
            return parse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return s;
        }
    }

    private Object toJson(String value) {
        try {
            return JsonUtil.isJson(value) ? JSON.parse((String)value) : value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return value;
        }
    }
}

