/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.interceptor.impl;

import cn.com.duiba.cloud.duiba.http.client.context.HttpRequestContext;
import cn.com.duiba.cloud.duiba.http.client.context.form.Form;
import cn.com.duiba.cloud.duiba.http.client.interceptor.HttpClientInterceptor;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;

@Component
public class LogInterceptor
implements HttpClientInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LogInterceptor.class);

    @Override
    public Object httpAfter(HttpClientResponse response, Object rlt) throws Exception {
        String httpUrl = response.getHttpUrl();
        HttpRequestContext context = response.getContext();
        String body = context.getBody();
        List<Form> nameValueParams = context.getNameValueParams();
        String result = this.getResult(response, rlt);
        LogInfo logInfo = new LogInfo(httpUrl, body, nameValueParams, result);
        logger.info(JSON.toJSONString((Object)logInfo));
        return rlt;
    }

    @Override
    public Object httpException(HttpRequestContext context, Throwable e) throws Exception {
        String httpUrl = context.getHttpUrl();
        String body = context.getBody();
        List<Form> nameValueParams = context.getNameValueParams();
        LogInfo logInfo = new LogInfo(httpUrl, body, nameValueParams, null);
        logger.error(JSON.toJSONString((Object)logInfo), e);
        return null;
    }

    private String getResult(HttpClientResponse response, Object rlt) throws IOException {
        return rlt instanceof File || rlt instanceof MockMultipartFile ? "is file" : response.string();
    }

    public static class LogInfo {
        private String httpUrl;
        private String body;
        private List<Form> form;
        private String result;

        public LogInfo(String httpUrl, String body, List<Form> form, String result) {
            this.httpUrl = httpUrl;
            this.body = body;
            this.form = form;
            this.result = result;
        }

        public String getHttpUrl() {
            return this.httpUrl;
        }

        public void setHttpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public List<Form> getForm() {
            return this.form;
        }

        public void setForm(List<Form> form) {
            this.form = form;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}

