/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.proxy;

import cn.com.duiba.cloud.duiba.http.client.bo.HttpClientRequest;
import cn.com.duiba.cloud.duiba.http.client.config.HttpClientConfig;
import cn.com.duiba.cloud.duiba.http.client.context.HttpRequestContext;
import cn.com.duiba.cloud.duiba.http.client.enums.HttpRequestMethod;
import cn.com.duiba.cloud.duiba.http.client.exception.ParamException;
import cn.com.duiba.cloud.duiba.http.client.factorybean.HttpFactoryBean;
import cn.com.duiba.cloud.duiba.http.client.handler.analysis.method.AnalysisMethodParamHandlerManager;
import cn.com.duiba.cloud.duiba.http.client.handler.http.request.SetHttpParamHandlerManager;
import cn.com.duiba.cloud.duiba.http.client.handler.http.result.HttpClientResultHandlerManager;
import cn.com.duiba.cloud.duiba.http.client.interceptor.HttpClientInterceptor;
import cn.com.duiba.cloud.duiba.http.client.proxy.HttpProxy;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.SpringUtil;
import cn.com.duiba.cloud.duiba.http.client.utils.UrlUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHttpProxy
implements HttpProxy,
InvocationHandler {
    private HttpFactoryBean httpFactoryBean;
    private List<HttpClientInterceptor> httpClientInterceptorList;
    private HttpClientConfig httpClientConfig;

    @Override
    public <T> T newProxyInstance() {
        Class<?> clazz = this.httpFactoryBean.getType();
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        HttpRequestContext context = new HttpRequestContext(this.httpFactoryBean, proxy, method, args);
        return this.sendHttp(context);
    }

    private Object sendHttp(HttpRequestContext context) throws Throwable {
        try {
            this.analysisMethodParam(context);
            this.setHttpUrl(context);
            Object rlt = this.runHttpBefore(context);
            if (Objects.nonNull(rlt)) {
                return rlt;
            }
            HttpClientResponse response = this.doInvoke(context);
            response.setContext(context);
            rlt = HttpClientResultHandlerManager.getReturnObject(response);
            return this.runHttpAfter(response, rlt);
        }
        catch (Throwable throwable) {
            Object rlt = this.runHttpException(context, throwable);
            if (Objects.nonNull(rlt)) {
                return rlt;
            }
            throw throwable;
        }
    }

    protected abstract HttpClientResponse doInvoke(HttpRequestContext var1) throws Throwable;

    private Object runHttpException(HttpRequestContext context, Throwable e) throws Exception {
        Object rlt = null;
        for (HttpClientInterceptor httpClientInterceptor : this.getHttpClientInterceptorList()) {
            rlt = httpClientInterceptor.httpException(context, e);
        }
        return rlt;
    }

    protected boolean isGet(HttpRequestContext context) {
        HttpRequestMethod httpRequestMethod = context.getHttpRequestMethod();
        return HttpRequestMethod.POST != httpRequestMethod;
    }

    protected void analysisMethodParam(HttpRequestContext context) throws Exception {
        Object[] args = context.getArgs();
        Annotation[][] parameterAnnotations = context.getParameterAnnotations();
        HttpClientRequest result = new HttpClientRequest();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                Annotation[] parameterAnnotation = parameterAnnotations[i];
                Object methodParam = AnalysisMethodParamHandlerManager.analysisMethodParam(arg, parameterAnnotation);
                SetHttpParamHandlerManager.setHttpParam(result, methodParam);
            }
        }
        context.setParam(result);
    }

    public void setHttpUrl(HttpRequestContext context) {
        if (StringUtils.isBlank((CharSequence)context.getHttpUrl())) {
            if (Objects.isNull(context.getParam()) || Objects.isNull((Object)context.getHttpRequestMethod())) {
                throw new ParamException("\u6570\u636e\u5f02\u5e38,methodParamResult or httpRequestMethod is null");
            }
            String baseUrl = context.getBaseUrl(this.getConfig().getBaseUrl());
            if (this.isGet(context) || context.isPostEntity()) {
                context.setHttpUrl(UrlUtil.getParamUrl(baseUrl, context.getNameValueParams()));
            } else {
                context.setHttpUrl(baseUrl);
            }
        }
    }

    protected HttpClientConfig getConfig() {
        if (Objects.isNull(this.httpClientConfig)) {
            this.httpClientConfig = SpringUtil.getBean(HttpClientConfig.class);
        }
        return this.httpClientConfig;
    }

    private Object runHttpBefore(HttpRequestContext context) throws Exception {
        for (HttpClientInterceptor httpClientInterceptor : this.getHttpClientInterceptorList()) {
            Object rlt = httpClientInterceptor.httpBefore(context);
            if (!Objects.nonNull(rlt)) continue;
            return rlt;
        }
        return null;
    }

    private Object runHttpAfter(HttpClientResponse response, Object rlt) throws Exception {
        for (HttpClientInterceptor httpClientInterceptor : this.getHttpClientInterceptorList()) {
            rlt = httpClientInterceptor.httpAfter(response, rlt);
        }
        return rlt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<HttpClientInterceptor> getHttpClientInterceptorList() {
        if (this.httpClientInterceptorList != null) return this.httpClientInterceptorList;
        Class<AbstractHttpProxy> clazz = AbstractHttpProxy.class;
        synchronized (AbstractHttpProxy.class) {
            if (this.httpClientInterceptorList != null) return this.httpClientInterceptorList;
            this.httpClientInterceptorList = SpringUtil.getBeanList(HttpClientInterceptor.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.httpClientInterceptorList;
        }
    }

    public HttpFactoryBean getHttpFactoryBean() {
        return this.httpFactoryBean;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void setHttpFactoryBean(HttpFactoryBean httpFactoryBean) {
        this.httpFactoryBean = httpFactoryBean;
    }

    public void setHttpClientInterceptorList(List<HttpClientInterceptor> httpClientInterceptorList) {
        this.httpClientInterceptorList = httpClientInterceptorList;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHttpProxy)) {
            return false;
        }
        AbstractHttpProxy other = (AbstractHttpProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpFactoryBean this$httpFactoryBean = this.getHttpFactoryBean();
        HttpFactoryBean other$httpFactoryBean = other.getHttpFactoryBean();
        if (this$httpFactoryBean == null ? other$httpFactoryBean != null : !this$httpFactoryBean.equals(other$httpFactoryBean)) {
            return false;
        }
        List<HttpClientInterceptor> this$httpClientInterceptorList = this.getHttpClientInterceptorList();
        List<HttpClientInterceptor> other$httpClientInterceptorList = other.getHttpClientInterceptorList();
        if (this$httpClientInterceptorList == null ? other$httpClientInterceptorList != null : !((Object)this$httpClientInterceptorList).equals(other$httpClientInterceptorList)) {
            return false;
        }
        HttpClientConfig this$httpClientConfig = this.getHttpClientConfig();
        HttpClientConfig other$httpClientConfig = other.getHttpClientConfig();
        return !(this$httpClientConfig == null ? other$httpClientConfig != null : !((Object)this$httpClientConfig).equals(other$httpClientConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractHttpProxy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpFactoryBean $httpFactoryBean = this.getHttpFactoryBean();
        result = result * 59 + ($httpFactoryBean == null ? 43 : $httpFactoryBean.hashCode());
        List<HttpClientInterceptor> $httpClientInterceptorList = this.getHttpClientInterceptorList();
        result = result * 59 + ($httpClientInterceptorList == null ? 43 : ((Object)$httpClientInterceptorList).hashCode());
        HttpClientConfig $httpClientConfig = this.getHttpClientConfig();
        result = result * 59 + ($httpClientConfig == null ? 43 : ((Object)$httpClientConfig).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractHttpProxy(httpFactoryBean=" + this.getHttpFactoryBean() + ", httpClientInterceptorList=" + this.getHttpClientInterceptorList() + ", httpClientConfig=" + this.getHttpClientConfig() + ")";
    }
}

