/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.proxy;

import cn.com.duiba.cloud.duiba.http.client.context.HttpRequestContext;
import cn.com.duiba.cloud.duiba.http.client.context.body.FileBody;
import cn.com.duiba.cloud.duiba.http.client.context.form.Form;
import cn.com.duiba.cloud.duiba.http.client.context.header.HttpHeader;
import cn.com.duiba.cloud.duiba.http.client.factorybean.HttpFactoryBean;
import cn.com.duiba.cloud.duiba.http.client.proxy.AbstractHttpProxy;
import cn.com.duiba.cloud.duiba.http.client.response.HttpClientResponse;
import cn.com.duiba.cloud.duiba.http.client.utils.IoStreamUtils;
import cn.com.duiba.cloud.duiba.http.client.utils.SpringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpProxy
extends AbstractHttpProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpProxy.class);
    private HttpFactoryBean httpFactoryBean;
    private CloseableHttpClient client;
    public static final String DEFAULT_ENCODING = "UTF-8";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HttpClientResponse doInvoke(HttpRequestContext context) throws Throwable {
        Object httpRequest = this.isGet(context) ? new HttpGet(context.getHttpUrl()) : this.getHttpPost(context);
        this.setHeader((HttpRequestBase)httpRequest, context);
        try (CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)httpRequest);){
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            InputStream content = entity.getContent();
            HttpHeader headers = this.getHeaders(response);
            Charset charset = this.getCharset(entity);
            HttpClientResponse httpClientResponse = HttpClientResponse.builder().charset(charset).httpHeader(headers).inputStream(IoStreamUtils.copyInputStream(content)).code(statusCode).build();
            return httpClientResponse;
        }
    }

    private void setHeader(HttpRequestBase httpRequest, HttpRequestContext context) {
        Map<String, List<String>> headers = context.getHttpHeader().getHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                httpRequest.addHeader(key, value);
            }
        }
    }

    private Charset getCharset(HttpEntity entity) {
        ContentType contentType = ContentType.get((HttpEntity)entity);
        if (Objects.nonNull(contentType)) {
            return contentType.getCharset();
        }
        return HTTP.DEF_CONTENT_CHARSET;
    }

    private HttpHeader getHeaders(CloseableHttpResponse response) {
        Header[] allHeaders = response.getAllHeaders();
        HttpHeader httpHeader = new HttpHeader();
        for (Header header : allHeaders) {
            httpHeader.addHeader(header.getName(), header.getValue());
        }
        return httpHeader;
    }

    private HttpRequestBase getHttpPost(HttpRequestContext context) throws Throwable {
        String body = context.getBody();
        String url = context.getHttpUrl();
        HttpPost httpPost = new HttpPost(url);
        HttpEntity entity = this.getHttpEntity(context);
        if (entity != null) {
            httpPost.setEntity(entity);
        }
        return httpPost;
    }

    private HttpEntity getHttpEntity(HttpRequestContext context) throws IOException {
        List<Form> nameValueParams;
        if (StringUtils.isNotBlank((String)context.getBody())) {
            return new StringEntity(context.getBody(), DEFAULT_ENCODING);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        List<FileBody> uploadFiles = context.getUploadFiles();
        if (CollectionUtils.isNotEmpty(uploadFiles)) {
            FileBody fileBody = uploadFiles.get(0);
            ByteArrayBody byteArrayBody = new ByteArrayBody(fileBody.getFileBytes(), fileBody.getFileName());
            String value = StringUtils.isBlank((String)fileBody.getName()) ? "file" : fileBody.getName();
            builder.addPart(value, (ContentBody)byteArrayBody);
        }
        if (CollectionUtils.isNotEmpty(nameValueParams = context.getNameValueParams())) {
            for (Form nameValueParam : nameValueParams) {
                builder.addTextBody(nameValueParam.getName(), nameValueParam.getValue(), nameValueParam.getContentType());
            }
        }
        return builder.build();
    }

    public CloseableHttpClient getClient() {
        if (Objects.isNull(this.client)) {
            this.client = SpringUtil.getBean(CloseableHttpClient.class);
        }
        return this.client;
    }
}

