/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.registrar;

import cn.com.duiba.cloud.duiba.http.client.annotation.EnableHttpClient;
import cn.com.duiba.cloud.duiba.http.client.annotation.HttpClient;
import cn.com.duiba.cloud.duiba.http.client.annotation.HttpClientProxy;
import cn.com.duiba.cloud.duiba.http.client.factorybean.HttpFactoryBean;
import cn.com.duiba.cloud.duiba.http.client.proxy.AbstractHttpProxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HttpClientRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(HttpClient.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        Set<String> basePackages = this.getBasePackages(importingClassMetadata);
        Class<? extends AbstractHttpProxy> defaultProxy = this.getDefaultProxyClass(importingClassMetadata);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@HttpClient \u53ea\u80fd\u4f5c\u7528\u5728\u63a5\u53e3\u7c7b\u578b\u4e0a");
                this.register(registry, annotationMetadata, defaultProxy);
            }
        }
    }

    private Class<? extends AbstractHttpProxy> getDefaultProxyClass(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableHttpClient.class.getCanonicalName());
        if (attributes != null) {
            return (Class)attributes.get("defaultProxy");
        }
        return null;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableHttpClient.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        if (attributes != null) {
            for (String pkg : (String[])attributes.get("basePackages")) {
                if (!StringUtils.isNotBlank((CharSequence)pkg)) continue;
                basePackages.add(pkg);
            }
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private void register(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Class<? extends AbstractHttpProxy> defaultProxy) {
        Map httpClientAttributes = annotationMetadata.getAnnotationAttributes(HttpClient.class.getCanonicalName());
        Map httpClientProxyAttributes = annotationMetadata.getAnnotationAttributes(HttpClientProxy.class.getCanonicalName());
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(HttpFactoryBean.class);
        definition.addPropertyValue("url", httpClientAttributes.get("url"));
        definition.addPropertyValue("method", httpClientAttributes.get("method"));
        definition.addPropertyValue("pathMethodName", httpClientAttributes.get("pathMethodName"));
        definition.addPropertyValue("type", (Object)className);
        definition.addPropertyValue("basePath", httpClientAttributes.get("path"));
        if (Objects.nonNull(httpClientProxyAttributes)) {
            definition.addPropertyValue("proxyClass", httpClientProxyAttributes.get("value"));
        } else {
            definition.addPropertyValue("proxyClass", defaultProxy);
        }
        definition.setAutowireMode(2);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setPrimary(true);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, new String[0]);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }
}

