/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.response;

import cn.com.duiba.cloud.duiba.http.client.context.HttpRequestContext;
import cn.com.duiba.cloud.duiba.http.client.context.header.HttpHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public class HttpClientResponse {
    private int code;
    private final Charset charset;
    private HttpHeader httpHeader = new HttpHeader();
    private HttpRequestContext context;
    private InputStream inputStream;
    private String result;

    private Charset charset() {
        return this.charset != null ? this.charset : Charset.forName("UTF-8");
    }

    public String string() throws IOException {
        if (Objects.isNull(this.result)) {
            this.result = new String(this.getByte(), this.charset().name());
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByte() throws IOException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = this.inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            if (Objects.nonNull(this.inputStream)) {
                this.inputStream.close();
            }
        }
    }

    public String getHeader(String name) {
        return this.httpHeader.getHeader(name, null);
    }

    public String getHttpUrl() {
        return this.context.getHttpUrl();
    }

    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    HttpClientResponse(int code, Charset charset, HttpHeader httpHeader, HttpRequestContext context, InputStream inputStream, String result) {
        this.code = code;
        this.charset = charset;
        this.httpHeader = httpHeader;
        this.context = context;
        this.inputStream = inputStream;
        this.result = result;
    }

    public static HttpClientResponseBuilder builder() {
        return new HttpClientResponseBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    public HttpRequestContext getContext() {
        return this.context;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getResult() {
        return this.result;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHttpHeader(HttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }

    public void setContext(HttpRequestContext context) {
        this.context = context;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientResponse)) {
            return false;
        }
        HttpClientResponse other = (HttpClientResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        HttpHeader this$httpHeader = this.getHttpHeader();
        HttpHeader other$httpHeader = other.getHttpHeader();
        if (this$httpHeader == null ? other$httpHeader != null : !this$httpHeader.equals(other$httpHeader)) {
            return false;
        }
        HttpRequestContext this$context = this.getContext();
        HttpRequestContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        InputStream this$inputStream = this.getInputStream();
        InputStream other$inputStream = other.getInputStream();
        if (this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        HttpHeader $httpHeader = this.getHttpHeader();
        result = result * 59 + ($httpHeader == null ? 43 : $httpHeader.hashCode());
        HttpRequestContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        InputStream $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientResponse(code=" + this.getCode() + ", charset=" + this.getCharset() + ", httpHeader=" + this.getHttpHeader() + ", context=" + this.getContext() + ", inputStream=" + this.getInputStream() + ", result=" + this.getResult() + ")";
    }

    public static class HttpClientResponseBuilder {
        private int code;
        private Charset charset;
        private HttpHeader httpHeader;
        private HttpRequestContext context;
        private InputStream inputStream;
        private String result;

        HttpClientResponseBuilder() {
        }

        public HttpClientResponseBuilder code(int code) {
            this.code = code;
            return this;
        }

        public HttpClientResponseBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public HttpClientResponseBuilder httpHeader(HttpHeader httpHeader) {
            this.httpHeader = httpHeader;
            return this;
        }

        public HttpClientResponseBuilder context(HttpRequestContext context) {
            this.context = context;
            return this;
        }

        public HttpClientResponseBuilder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public HttpClientResponseBuilder result(String result) {
            this.result = result;
            return this;
        }

        public HttpClientResponse build() {
            return new HttpClientResponse(this.code, this.charset, this.httpHeader, this.context, this.inputStream, this.result);
        }

        public String toString() {
            return "HttpClientResponse.HttpClientResponseBuilder(code=" + this.code + ", charset=" + this.charset + ", httpHeader=" + this.httpHeader + ", context=" + this.context + ", inputStream=" + this.inputStream + ", result=" + this.result + ")";
        }
    }
}

