/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.http.client.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class AutoCloseUtil {
    private static final ThreadLocal<List<Closeable>> THREAD_LOCAL = new ThreadLocal<List<Closeable>>(){

        @Override
        protected List<Closeable> initialValue() {
            return new ArrayList<Closeable>();
        }
    };

    public static void addCloseable(Closeable closeable) {
        THREAD_LOCAL.get().add(closeable);
    }

    public static void closeAll() {
        List<Closeable> closeables = THREAD_LOCAL.get();
        if (CollectionUtils.isNotEmpty(closeables)) {
            for (Closeable closeable : closeables) {
                try {
                    if (!Objects.nonNull(closeable)) continue;
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
        AutoCloseUtil.clear();
    }

    public static void clear() {
        THREAD_LOCAL.get().clear();
    }
}

